IF EXISTS (SELECT *
           FROM   sys.objects
           WHERE  object_id = OBJECT_ID(N'[dbo].[UFD_CAMELCASE]')
                  AND type IN ( N'FN', N'IF', N'TF', N'FS', N'FT' ))
    BEGIN
	   DROP FUNCTION [dbo].[UFD_CAMELCASE];
    END
    GO

CREATE FUNCTION [dbo].[UFD_CAMELCASE] (@INPUTSTRING VARCHAR(4000)) 
RETURNS VARCHAR(4000) 
AS 
BEGIN 
	DECLARE @INDEX INT 
	DECLARE @CHAR CHAR(1) 
	DECLARE @OUTPUTSTRING VARCHAR(255) 

	SET @OUTPUTSTRING = Lower(@INPUTSTRING) 
	SET @INDEX = 2 
	SET @OUTPUTSTRING = Stuff(@OUTPUTSTRING, 1, 1, Upper( 
					  Substring(@INPUTSTRING, 1, 1))) 

	WHILE @INDEX <= Len(@INPUTSTRING) 
		BEGIN 
			SET @CHAR = Substring(@INPUTSTRING, @INDEX, 1) 

			IF @CHAR IN ( ' ', ';', ':', '!', 
					  '?', ',', '.', '_', 
					  '-', '/', '&', '''', '(' ) 
			IF @INDEX + 1 <= Len(@INPUTSTRING) 
				BEGIN 
					IF @CHAR != '''' 
						OR Upper(Substring(@INPUTSTRING, @INDEX + 1, 1)) != 'S' 
					SET @OUTPUTSTRING = Stuff(@OUTPUTSTRING, @INDEX + 1, 1,Upper(Substring(@INPUTSTRING , @INDEX + 1, 1))) 
				END 

			SET @INDEX = @INDEX + 1 
		END 

	RETURN ISNULL(Stuff(Replace(@OUTPUTSTRING, '_', ''), 1, 1,Lower(LEFT(@OUTPUTSTRING, 1))), '') 
END 
